<?php
declare(strict_types=1);

// Single entry point for both the SPA and API.

$uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?? '/';

if (str_starts_with($uri, '/api/') || $uri === '/events') {
  require_once __DIR__ . '/../app/routes.php';
  exit;
}

// Serve uploaded assets
if (str_starts_with($uri, '/uploads/')) {
  $path = __DIR__ . $uri;
  if (!file_exists($path) || !is_file($path)) {
    http_response_code(404);
    echo 'Not found';
    exit;
  }
  $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
  $map = [
    'png' => 'image/png',
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'svg' => 'image/svg+xml',
    'ico' => 'image/x-icon',
    'webp' => 'image/webp',
  ];
  header('Content-Type: ' . ($map[$ext] ?? 'application/octet-stream'));
  header('Cache-Control: public, max-age=3600');
  readfile($path);
  exit;
}

// Default to app
readfile(__DIR__ . '/app.html');
